#  expireWhatsNewItems.pl
#
#  Removes expired items from the "What's new" section of my
#  Agora home page.  Updates the page's date if changed.
#
#  Note that this script assumes a very rigid format, with
#  fixed indentation and spacing in the META tags.  Also,
#  the "What's new" section is expected to be bracketed by
#  delimiting comments, like so:
#
#    <!-- Start what's new section -->
#    <P>a header line
#    link 1 <!-- EXPIRES="yyyy-mm-dd" -->
#    &middot;&middot;&middot; link 2 <!-- EXPIRES="yyyy-mm-dd" -->
#    &middot;&middot;&middot; link 3 <!-- EXPIRES="yyyy-mm-dd" -->
#    </P>
#    <!-- End what's new section -->
#
#  If all links have expired, this script comments out the section's
#  header line as well.  The quotes around the ISO-format expiration
#  date are optional.
#
#  Mark L. Irons
#  10-11 November 2000
#
#--------------------------------------------------------------------
#
#  Patterns to match
#
#  METADatePattern looks like '  <META NAME="date"         CONTENT="2000-07-17">'
#
$METADatePattern = '^  <META NAME="date"         CONTENT="(\d\d\d\d)-(\d\d)-(\d\d)">';
#
#  Define section boundaries
#
$sectionOpenPattern  = "^<!-- Start what's new section -->";
$sectionClosePattern = "^<!-- End what's new section -->";
#
#  Define expiration date pattern
#
$expiresPattern = '<!-- EXPIRES="?(\d\d\d\d-\d\d-\d\d)"? -->';
#
#--------------------------------------------------------------------
#  Get current date and convert it to ISO format
#
($s,$m,$h,$curDay,$curMon,$curYear,$w,$y,$d) = localtime;
$curYear=$curYear+1900;                       # living in 21st century
$curMon=$curMon+1;                            # Jan is 1st month, not 0th
if ($curMon < 10) { $curMon = "0".$curMon; }  # pad month to two digits
if ($curDay < 10) { $curDay = "0".$curDay; }  # pad day to two digits
$curDate = $curYear."-".$curMon."-".$curDay;  # put it all together
#
#--------------------------------------------------------------------
#
if (!open(HTMLFILE,"Agora/index.html")) {
  warn "Can't open file, exiting.\n";
  exit;
}

$modifiedFlag = 0;                    # haven't changed file
$chunk1 = "";                         # text before META date
$dateline = "";                       # META date line
$chunk2 = "";                         # text between META date and What's new section
$whatsNew = "";                       # text of What's new section
$chunk3 = "";                         # text after What's new section

while (<HTMLFILE>) {                  # get first chunk
  if (/$METADatePattern/) {
    $dateline = $_;
    $dateline_ISOdate = $1."-".$2."-".$3;
    last;
  }
  $chunk1 .= $_;
}

while (<HTMLFILE>) {                  # get second chunk
  if (/$sectionOpenPattern/) {
    $whatsNewOpen = $_;
    $whatsNewBoilerplate = <HTMLFILE>;
    last;
  }
  $chunk2 .= $_;
}

$newStuff = 0;
$whatsStillNew = "";
$done = 0;                            # 0 is false
while (!$done) {                      # get What's new section
  $_ = <HTMLFILE>;
  if (/$sectionClosePattern/) {
    $whatsNewClose = $_;
    $done = 1;
  }
  else {
    if (/$expiresPattern/) {
      if ($1 le $curDate) {           # $1 is ISO date from EXPIRES=""
        $modifiedFlag = 1;
      }
      else {
        $newStuff++;
        $whatsStillNew .= $_;
      }
    }
    else {
      $whatsStillNew .= $_;
    }
  }
}

if ($modifiedFlag) {                  # Patch up date line if need be
  $dateline =~ s/$dateline_ISOdate/$curDate/;
}

$whatsNew = $whatsNewOpen;            # Rebuild What's new section
if ($newStuff == 0) {
  $whatsNew .= "<!--\n";
}
$whatsNew .= $whatsNewBoilerplate;
if ($newStuff > 0) {
  $whatsNew .= $whatsStillNew;
}
if ($newStuff == 0) {
  $whatsNew .= "-->\n";
}
$whatsNew .= $whatsNewClose;

while (<HTMLFILE>) {                 # get rest of file
  $chunk3 .= $_;
}

close HTMLFILE;

if ($modifiedFlag) {
  if (!open(OUTFILE,"> Agora/index.html")) {
    warn "Can't open output file, exiting.\n";
    exit;
  }
  print OUTFILE $chunk1;
  print OUTFILE $dateline;
  print OUTFILE $chunk2;
  print OUTFILE $whatsNew;
  print OUTFILE $chunk3;
  close OUTFILE;
  print "Removed expired \"What's new\" items from home page.\n";
}
