#  syncweb.pl
#
#  FTPs recently changed files from a local copy of a
#  Web site to a copy on a remote HTTP server. Determining
#  which files have been changed is done via 'find -newer',
#  comparing files to a special synchronization file in the
#  root directory of the local copy.
#
#  This program uses the CygWin Unix utilities for DOS,
#  available at http://sourceware.cygnus.com/cygwin
#
#  Mark L. Irons
#  24-25 May 2001


use Net::FTP;


#--------------------------------------------------------------------
#  Global variables
#

$synch_file = 'synch.$$$';    # This is the synchronization file. The
                              # only part of this file we care about
                              # is its timestamp.


#--------------------------------------------------------------------
#  We need to be in the root of the local copy of a Web site for this
#  to work. You'll need to change /local-Web-root to the location of
#  your local copy of your Web site.
#

chdir('/local-Web-root')
    || die "Failed: couldn't change to local Web directory.\n";


#--------------------------------------------------------------------
#  Check that the synchronization file exists. Die if it doesn't.
#

open(SYNCHFILE,"$synch_file")
    || die "Failed: no synchronization file '$synch_file'.\n";


#--------------------------------------------------------------------
#  Get a list of files newer than the synch file, and put them in
#  TOUCHED.
#

open(TOUCHED,"find . -noleaf -newer $synch_file |")
    || die "Failed: couldn't get list of updated files via 'find -newer'.\n";


#--------------------------------------------------------------------
#  Ask the user for the FTP server pass phrase. We use stty so that
#  we don't echo the pass phrase to the screen.
#

print "Enter pass phrase: ";
system "stty -echo";
$passphrase = <STDIN>;
chop $passphrase;
print "\n";


#--------------------------------------------------------------------
#  Create an FTP client and transfer the files.
#
#  You'll need to change the following to reflect your configuration:
#
#     o  user
#     o  remote-ftp-server
#     o  remote-home-directory
#

$ftp = Net::FTP->new("remote-ftp-server", Debug => 0);
$ftp->login('user',"$passphrase");
$passphrase = '';
$ftp->cwd('remote-home-directory');
$mode = 'T';                                # T for text, B for binary
while (<TOUCHED>) {
    chop;
    if (-d $_) {                            # create directory
        print "Creating directory $_\n";
        $ftp->mkdir($_,1);
        next;
    }
    elsif (-T $_ && $mode eq 'B') {         # set text mode if necessary
        $ftp->ascii();
        $mode = 'T';
    }
    elsif ($mode eq 'T') {                  # set binary mode if necessary
        $ftp->binary();
        $mode = 'B';
    }
    print "Uploading $_\n";
    $ftp->put($_,$_);                       # upload file
}
$ftp->quit;


#--------------------------------------------------------------------------
#  Touch the synch file to set things up for next time.
#

system "touch $synch_file"
    || die "Failed to update $synch_file's timestamp. Please do so manually.\n";

print "Synchronization complete.\n";
