#  updateFooterDates.pl
#
#  Process a list of HTML files, checking their internal last
#  updated META tag (NAME="date").  If the value of the date in
#  the page footer is earlier, change it to the META date.
#
#  Assumption: the META tag will precede the page footer.  This
#  is a safe assumption, since the META tag should be in the
#  <HEAD> section and the footer should be in the <BODY>.
#  Note that the footer date pattern is very specific.  See
#  code for details.
#
#  The <META> date tag must have this format:
#
#     <META NAME="date" CONTENT="yyyy-mm-dd">
#
#  The date in the META tag must be in ISO format, e.g. 2001-11-26
#  is 26 November, 2001.
#
#  The "last updated" line in the footer must have this format:
#
#     <P><SMALL>Last updated dd month year<BR>
#
#  e.g., <P><SMALL>Last updated 26 November 2001<BR>. The date on
#  this line can be either 1 or 2 digits.
#
#  Input: a list of files to process.
#
#  Mark L. Irons
#  18 July 2000
#
#--------------------------------------------------------------------
#  Array of months
#
@months = ('January','February','March','April','May','June',
           'July','August','September','October','November','December');
#
#--------------------------------------------------------------------
#
#  Patterns to match.
#
#  METADatePattern looks like '<META NAME="date" CONTENT="2000-07-17">'
#
$METADatePattern = '<META NAME="date"[ ]+CONTENT="(\d\d\d\d)-(\d\d)-(\d\d)">';
#
#  footerDatePattern looks like '<P><SMALL>Last updated 17 July 2000<BR>'
#
$footerDatePattern = '^(<P><SMALL>Last updated )(\d\d? [A-Z][a-z]+ \d\d\d\d)(<BR>)$';
#
#--------------------------------------------------------------------
#  Loop over files, processing each.
#
while (<>) {
  $filename = $_;
  if (!open(HTMLFILE,$filename)) {
    chop $filename;
    warn "Can't open $filename, skipping: $!\n";
    next;
  }
  $modifiedFlag = 0;                    # haven't changed file
  $modifiedFile = "";                   # text of modified file
  $readableDate = "";
  while (<HTMLFILE>) {
    if (/$METADatePattern/) {           # check for META date tag
      $year = $1;
      $month = $2;
      $day = $3;
      if (substr($day,0,1) eq "0") {
        $day = substr($day,1,1);
      }
      $month = $months[$month-1];
      $readableDate = "$day $month $year";
    }
    elsif (/$footerDatePattern/) {
      if (($readableDate ne "") && ($2 ne $readableDate)) {
        $_ =  $1.$readableDate.$3."\n";
        $modifiedFlag = 1;
      }
    }
    $modifiedFile .= $_;
  } # processing single file
  close(HTMLFILE);                      # close the input file
  if ($modifiedFlag) {
    if (open(HTMLFILE,"> ".$filename)) {
      print HTMLFILE $modifiedFile;     # write the modified contents
      close HTMLFILE;                   # and close it of course
      print "Updated dates in $filename";   # print names of modified files
    }
  }
} # all files
